/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextComponentElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class ContentMaterial
extends PageContent {
    private static final Component PART_BUILDER = TConstruct.makeTranslation("book", "material.part_builder");
    private static final String CAST_FROM = TConstruct.makeTranslationKey("book", "material.cast_from");
    private static final String COMPOSITE_FROM = TConstruct.makeTranslationKey("book", "material.composite_from");
    public static final ResourceLocation ID = TConstruct.getResource("toolmaterial");
    private transient MaterialVariantId materialVariant;
    private transient List<ItemStack> repairStacks;
    private transient IMaterial material;
    @SerializedName(value="material")
    public String materialName;
    public boolean detailed;

    public ContentMaterial(MaterialVariantId materialVariant, boolean detailed) {
        this.materialName = materialVariant.toString();
        this.materialVariant = materialVariant;
        this.detailed = detailed;
    }

    protected MaterialVariantId getMaterialVariant() {
        if (this.materialVariant == null) {
            this.materialVariant = MaterialVariantId.parse(this.materialName);
        }
        return this.materialVariant;
    }

    protected IMaterial getMaterial() {
        if (this.material == null) {
            this.material = MaterialRegistry.getMaterial(this.getMaterialVariant().getId());
        }
        return this.material;
    }

    protected List<ItemStack> getRepairStacks() {
        if (this.repairStacks == null) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return Collections.emptyList();
            }
            MaterialVariantId material = this.getMaterialVariant();
            this.repairStacks = RecipeHelper.getUIRecipes((RecipeManager)world.m_7465_(), (RecipeType)((RecipeType)TinkerRecipeTypes.MATERIAL.get()), MaterialRecipe.class, recipe -> material.matchesVariant(recipe.getMaterial())).stream().flatMap(recipe -> Arrays.stream(recipe.getIngredient().m_43908_())).collect(Collectors.toList());
            if (this.repairStacks.isEmpty()) {
                TConstruct.LOG.debug("Material with id " + material + " has no representation items associated with it, using repair kit");
                this.repairStacks = Collections.singletonList(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(material));
            }
        }
        return this.repairStacks;
    }

    public List<ItemStack> getDisplayStacks() {
        return this.getRepairStacks();
    }

    @Nonnull
    public String getTitle() {
        return this.getTitleComponent().getString();
    }

    public Component getTitleComponent() {
        return MaterialTooltipCache.getDisplayName(this.getMaterialVariant());
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        MaterialVariantId materialVariant = this.getMaterialVariant();
        this.addTitle(list, this.getTitle(), true, MaterialTooltipCache.getColor(materialVariant).m_131265_());
        this.addDisplayItems(list, rightSide ? 164 : 0, materialVariant);
        int col_margin = 22;
        int top = this.getTitleHeight();
        int left = rightSide ? 0 : col_margin;
        int y = top + 5;
        int x = left + 5;
        int w = 86;
        MaterialId material = materialVariant.getId();
        int headTraits = this.addStatsDisplay(x, y, w, list, material, HeadMaterialStats.ID);
        int handleTraits = this.addStatsDisplay(x + w, y, w - 10, list, material, HandleMaterialStats.ID);
        this.addStatsDisplay(x, (y += 65) + 10 * headTraits, w, list, material, ExtraMaterialStats.ID);
        String textKey = String.format(this.detailed ? "material.%s.%s.encyclopedia" : "material.%s.%s.flavor", material.m_135827_(), material.m_135815_());
        if (I18n.m_118936_((String)textKey)) {
            Object translated = ForgeI18n.getPattern((String)textKey);
            if (!this.detailed) {
                translated = "\"" + (String)translated + "\"";
            }
            TextData flavourData = new TextData((String)translated);
            flavourData.italic = !this.detailed;
            list.add((BookElement)new TextElement(x + w - 16, y + 10 * handleTraits, w, 60, new TextData[]{flavourData}));
        }
    }

    protected int addStatsDisplay(int x, int y, int w, ArrayList<BookElement> list, MaterialId material, MaterialStatsId statsId) {
        Optional stats = MaterialRegistry.getInstance().getMaterialStats(material, statsId);
        if (stats.isEmpty()) {
            return 0;
        }
        List<ModifierEntry> traits = MaterialRegistry.getInstance().getTraits(material, statsId);
        LinkedList parts = Lists.newLinkedList();
        for (IToolPart part : this.getToolParts()) {
            if (part.getStatType() != statsId) continue;
            parts.add(part.withMaterial(material));
        }
        int textOffset = 0;
        if (!parts.isEmpty()) {
            TinkerItemElement display = new TinkerItemElement(x, y + 1, 0.5f, parts);
            list.add((BookElement)display);
            textOffset = 10;
        }
        TextElement name = new TextElement(x + textOffset, y, w - textOffset, 10, ((IMaterialStats)stats.get()).getLocalizedName().getString());
        name.text[0].bold = true;
        name.text[0].underlined = true;
        list.add((BookElement)name);
        y += 12;
        ArrayList lineData = Lists.newArrayList();
        lineData.addAll(ContentMaterial.getStatLines((IMaterialStats)stats.get()));
        lineData.addAll(ContentMaterial.getTraitLines(traits));
        list.add((BookElement)new TextComponentElement(x, y, w, 176, (Collection)lineData));
        return traits.size();
    }

    private static List<TextComponentData> getStatLines(IMaterialStats stats) {
        ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
        for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
            TextComponentData text = new TextComponentData(stats.getLocalizedInfo().get(i));
            text.tooltips = stats.getLocalizedDescriptions().get(i).getString().isEmpty() ? null : new Component[]{stats.getLocalizedDescriptions().get(i)};
            lineData.add(text);
            lineData.add(new TextComponentData("\n"));
        }
        return lineData;
    }

    private static List<TextComponentData> getTraitLines(List<ModifierEntry> traits) {
        ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
        for (ModifierEntry trait : traits) {
            Modifier mod = trait.getModifier();
            TextComponentData textComponentData = new TextComponentData(mod.getDisplayName());
            List<Component> textComponents = mod.getDescriptionList(trait.getLevel());
            textComponentData.tooltips = textComponents.toArray(new Component[0]);
            textComponentData.text = textComponentData.text.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.UNDERLINE});
            lineData.add(textComponentData);
            lineData.add(new TextComponentData("\n"));
        }
        return lineData;
    }

    private static boolean hasStatType(MaterialId materialId, MaterialStatsId statsId) {
        return MaterialRegistry.getInstance().getMaterialStats(materialId, statsId).isPresent();
    }

    private static IMaterial getFirstMaterialWithType(MaterialStatsId statsId) {
        for (IMaterial material : MaterialRegistry.getMaterials()) {
            if (!ContentMaterial.hasStatType(material.getIdentifier(), statsId)) continue;
            return material;
        }
        return IMaterial.UNKNOWN;
    }

    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)HeadMaterialStats.ID) || statsId.equals((Object)HandleMaterialStats.ID) || statsId.equals((Object)ExtraMaterialStats.ID);
    }

    protected void addPrimaryDisplayItems(List<ItemElement> displayTools, MaterialVariantId materialId) {
        List<MaterialFluidRecipe> fluids;
        TinkerItemElement elementItem;
        if (this.getMaterial().isCraftable()) {
            ItemStack partBuilder = new ItemStack((ItemLike)TinkerTables.partBuilder.m_5456_());
            elementItem = new TinkerItemElement(partBuilder);
            elementItem.tooltip = ImmutableList.of((Object)PART_BUILDER);
            displayTools.add(elementItem);
        }
        if (!(fluids = MaterialCastingLookup.getCastingFluids(materialId)).isEmpty()) {
            elementItem = new TinkerItemElement(0, 0, 1.0f, fluids.stream().flatMap(recipe -> recipe.getFluids().stream()).map(fluid -> new ItemStack((ItemLike)fluid.getFluid().m_6859_())).collect(Collectors.toList()));
            FluidStack firstFluid = fluids.stream().flatMap(recipe -> recipe.getFluids().stream()).findFirst().orElse(FluidStack.EMPTY);
            elementItem.tooltip = ImmutableList.of((Object)new TranslatableComponent(CAST_FROM, new Object[]{firstFluid.getFluid().getAttributes().getDisplayName(firstFluid)}));
            displayTools.add(elementItem);
        }
        List<MaterialFluidRecipe> composites = MaterialCastingLookup.getCompositeFluids(materialId);
        for (MaterialFluidRecipe composite : composites) {
            MaterialVariant input = composite.getInput();
            if (input == null) continue;
            MaterialVariantId inputId = input.getVariant();
            TinkerItemElement elementItem2 = new TinkerItemElement(0, 0, 1.0f, MaterialCastingLookup.getAllItemCosts().stream().map(Map.Entry::getKey).filter(part -> part.canUseMaterial(inputId.getId()) && part.canUseMaterial(this.material)).map(part -> part.withMaterial(inputId)).collect(Collectors.toList()));
            FluidStack firstFluid = composite.getFluids().stream().findFirst().orElse(FluidStack.EMPTY);
            elementItem2.tooltip = ImmutableList.of((Object)new TranslatableComponent(COMPOSITE_FROM, new Object[]{firstFluid.getFluid().getAttributes().getDisplayName(firstFluid), MaterialTooltipCache.getDisplayName(inputId)}));
            displayTools.add(elementItem2);
        }
    }

    protected void addDisplayItems(ArrayList<BookElement> list, int x, MaterialVariantId materialVariant) {
        ArrayList displayTools = Lists.newArrayList();
        displayTools.add(new TinkerItemElement(0, 0, 1.0f, this.getRepairStacks()));
        this.addPrimaryDisplayItems(displayTools, materialVariant);
        if (displayTools.size() < 9) {
            MaterialId materialId = materialVariant.getId();
            block0: for (Holder item : Registry.f_122827_.m_206058_(TinkerTags.Items.MULTIPART_TOOL)) {
                Object object = item.m_203334_();
                if (!(object instanceof IModifiable)) continue;
                IModifiable tool = (IModifiable)object;
                List<PartRequirement> requirements = tool.getToolDefinition().getData().getParts();
                MaterialNBT.Builder materials = MaterialNBT.builder();
                boolean usedMaterial = false;
                for (PartRequirement part : requirements) {
                    if (!this.supportsStatType(part.getStatType())) continue block0;
                    if (ContentMaterial.hasStatType(materialId, part.getStatType())) {
                        materials.add(materialVariant);
                        usedMaterial = true;
                        continue;
                    }
                    materials.add(ContentMaterial.getFirstMaterialWithType(part.getStatType()));
                }
                if (!usedMaterial) continue;
                ItemStack display = ToolBuildHandler.buildItemFromMaterials(tool, materials.build());
                displayTools.add(new TinkerItemElement(display));
                if (displayTools.size() != 9) continue;
                break;
            }
        }
        if (!displayTools.isEmpty()) {
            int y = this.getTitleHeight() - 5;
            for (ItemElement element : displayTools) {
                element.x = x;
                element.y = y;
                element.scale = 1.0f;
                y += 16;
                list.add((BookElement)element);
            }
        }
    }

    private List<IToolPart> getToolParts() {
        return RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, TinkerTags.Items.TOOL_PARTS).filter(item -> item instanceof IToolPart).map(item -> (IToolPart)item).collect(Collectors.toList());
    }
}

